/**********************************************************************************/
/*!
  \file Mid_DbmOSWrapper.h
  \li \c any OS         : yes
  \li \c Unicode        : yes but not tested

  ======================== Copyright =====================================
  \par License: Copyright &copy; 2009  Hilscher GmbH

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
   
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

  ========================================================================

  \section Mid_DbmOSWrapper_h_description Description:
  This file is included to solve all OS and Hardware dependencies.

  \manonly
  START of the SourceSafer tags
   Filename:
    $Workfile: Mid_DbmOSWrapper.h $
   Last Modification:
    $Author: Harald $
    $Modtime: 7.07.09 14:59 $
    $Revision: 4 $
  END of the SourceSafer tags
  \endmanonly

  \section Mid_DbmOSWrapper_h_history History:
  \version see <a href=".\OwnHtml\version.html" title="Versions">Versions</a>

  **************************************************************************************/
#ifndef __RX_DBMWRAPPER_H
  #define __RX_DBMWRAPPER_H

#include "Rx_Compiler.h"

#ifdef _MID_DBM_C_FROM_RCX
#ifndef __RCX__
#define __RCX__
#endif
#endif

#if defined(__GNUC__)
/*#pragma message ("-----> __GNUC__ defined <-----") #pragma message unknown in __GNUC__*/
#else
#if defined(_DEBUG)
#pragma message ("-----> _DEBUG defined <-----")
#endif
#if defined(_UNICODE)
#pragma message ("-----> _UNICODE defined <-----")
#endif
#ifdef _MSC_VER
#pragma message ("-----> _MSC_VER defined <-----")
#endif
#ifdef _WIN32
#pragma message ("-----> _WIN32 defined <-----")
#endif
#ifdef _WIN32_WCE
#pragma message ("-----> _WIN32_WCE defined <-----")
#endif
#ifdef __RCX__
/*#pragma message ("-----> __RCX__ defined <-----") #pragma message unknown in __GNUC__*/
#endif
#endif /*#if defined(__GNUC__)*/

/*****************************************************************************/

/* ****************************************************************************************************** 
   Insert Headers from your environment which must be included first
   ****************************************************************************************************** */
#ifdef _WIN32
  #define API_DECL                  /*< standard compiler calling convention */
#elif defined __RCX__
  #define API_DECL                  /*< standard compiler calling convention */
  #include "rX_types.h"
#elif defined _WIN32_WCE
  #define API_DECL                  /*< standard compiler calling convention */
#elif defined _UserDefinedName
  #define API_DECL                  /*< standard compiler calling convention */
#else
  #error Insert a pack definition for your current OS!
#endif

/* The following include define global types and structures and sould be included before doing anything else
*/
#include "HilFileHeaderV3.h"   /* Company wide file header */
#include "HilFileHeader.h"   /* Company wide file header */
#include "md5.h"   /* MD5 checksum */
#include "DbmRCX.h"   /* RCX Database management */
#include "rx_Results.h"
#include "dbm_Results.h"


#define RCX_DBMLIB 0x00020020ul /*Version 2.002*/

  /* ****************************************************************************************************** 
   Here the differentiation between the used OS start.
   ****************************************************************************************************** */
#ifdef __RCX__
/* ****************************************************************************************************** 
                          START of definitions when compiled with the OS rcX   
   ****************************************************************************************************** */
#define __OS_RCX
#define _MID_DATABASE_ENABLE_
#include "rX_Includes.h"
#include "rX_obj.h"

#ifndef UMD5_DEFINED
#define UMD5_DEFINED
typedef __PACKED_PRE union __PACKED_POST UMD5tag {
  unsigned char   m_abVal[16];	/*< 128 Bit as Byte Array*/
  unsigned short  m_ausVal[8];	/* 128 Bit as Word Array*/
  unsigned long   m_adwVal[4];	/*< 128 Bit as DWord Array*/
} UMD5;
#endif

/*Defines of wrapper functions*/
extern UINT32 MidSys_Crc32(UINT32 ulCrc, CONST UINT8 FAR* pbBuffer, UINT32 ulLength);

#define BOUNDARY      BOUNDARY_4 /*< The BOUNDARY macro will affect the writing of a database because 
each structure is written in a way that it will start on a boundary address.
For use in windows and on CE assume a 32bit prozessor and set the boundarys to 4Byte addresses*/
/* Keep the IS_BOUNDARY_ADR macro always available because it's also used in the release
*/
#define IS_BOUNDARY_ADR(a) ((((DWORD)a)%BOUNDARY==0)?TRUE:FALSE)
#define IS_RCSBOUNDARY_ADR(a) ((((DWORD)a)%BOUNDARY_2==0)?TRUE:FALSE)

extern unsigned long CreateCRC32(unsigned long ulCRC, unsigned char* pabBuffer, unsigned long ulLength);
DBMLIB_RESULT APCFG_WriteFile(CONST CHAR  FAR* pszFilename,
                          CONST UINT8 FAR* pbBuffer,
                          UINT32           ulBufferLen);
RX_FATAL FAR MidDynDatabaseInit( void FAR*        pvPar,
                                UINT             uPar);

/* ****************************************************************************************************** 
                              END of definitions when compiled with the OS rcX 
 ****************************************************************************************************** */

#endif /*#ifdef __RCX__*/

#if defined _WIN32 || defined _WIN32_WCE
/* ****************************************************************************************************** 
                          START of definitions when compiled with the OS Windows 
 ****************************************************************************************************** */
#define _MID_DATABASE_ENABLE_     /* Start compilation of the DBM Modules */
#define __OS_WIN32                /* define the OS to use during compilation */
//#pragma warning (push)
#pragma warning (disable: 4311)
#pragma message ("-----> Compile for WINDOWS <-----")

#ifdef __cplusplus
#endif /*#ifdef __cplusplus*/

/*  IncludeSection
    Include the files which are needed to compile the following lines
*/
#include <windows.h>
#include <basetsd.h>
#include <tchar.h>

#undef _RX_CHECK_INTEGRITY_

#undef FAR
#define FAR
#undef HUGE
#define HUGE

#define RX_FATAL  DBMLIB_RESULT
#define RX_HANDLE void FAR*

#ifndef __RCX_PUBLIC_H
typedef struct RCX_FILE_GET_MD5_CNF_DATA_Ttag
{
  UINT8                               abMD5[16];              /* MD5 checksum */
} RCX_FILE_GET_MD5_CNF_DATA_T;
#endif /*__RCX_PUBLIC_H*/

#define BOUNDARY      BOUNDARY_4 /*< The BOUNDARY macro will affect the writing of a database because 
each structure is written in a way that it will start on a boundary address.
For use in windows and on CE assume a 32bit prozessor and set the boundarys to 4Byte addresses*/
#define IS_BOUNDARY_ADR(a)    ((((DWORD)a)%BOUNDARY==0)?TRUE:FALSE)
#define IS_RCSBOUNDARY_ADR(a) ((((DWORD)a)%BOUNDARY_2==0)?TRUE:FALSE)

/* Because the Table names only support 1 byte character strings */
typedef char  STRING;
/*  String function mapping
*/
#define TCSNCMP   _tcsncmp
#define TCSLEN    _tcslen
#define TCSNCPY   _tcsncpy
#define TCSCPY    _tcscpy
#define TCSCMP    _tcscmp

#define STRNCMP   strncmp
#define STRLEN    strlen
#define STRNCPY   strncpy
#define STRCPY    strcpy
#define STRCMP    strcmp
/* Memory function definition */
#define MEMCPY    memcpy
#define MEMSET    memset
#define MEMCMP    memcmp

#ifndef __RX_OBJ_H
enum RX_OBJECT_TYPEtag {
  RX_OBJECT_FILE          = 29,
  RX_OBJECT_DBM           = 31
};
typedef UINT8 RX_OBJECT_TYPE;

typedef struct RX_OBJECT_HEADER_Ttag
{
  STRING                        szObjNam[16];   /*< Identification string as 15 + 1 byte String */
  RX_OBJECT_TYPE                eObjType;       /*< Type of Object */
  struct RX_OBJECT_HEADER_Ttag FAR* ptHdrSlf;       /*< Pointer to structure itself to detect if still valid */
} RX_OBJECT_HEADER_T;
#endif /*__RX_OBJ_H*/

#ifndef __AP_FAT_H
/* define the file access flags
*/
enum MID_FAT_FILEACCESStag {
  MID_FAT_FILEACCESS_NORMAL = 0,
  MID_FAT_FILEACCESS_READONLY = 1,
};

typedef int           MID_FAT_FILEACCESS;
#endif /*__AP_FAT_H*/

/* Validation
*/

#pragma warning ( disable: 4028 )

/*  The following is a mapping list of referenced functions in the DBM-Modules to the implementation
    in Mid_DbmOSWrapper.c.
    If the OS support the referenced function with the expected paremeter list nothing is do do here
    (see __OS_RCX)
*/
  #define MidDatabaseInit                     __OS_WIN32DatabaseInit
  #define Mid_DbmCloseDbmFile                 __OS_WIN32CloseDbmFile
  #define Mid_DbmOpenDbmFile                  __OS_WIN32OpenDbmFile
  #define MidSys_Crc32                        __OS_WIN32Crc32
  #define rX_MemAllocateMemory                __OS_WIN32AllocateMemory
  #define rX_MemFreeMemory                    __OS_WIN32FreeMemory
  #define APCFG_WriteFile                     __OS_WIN32WriteFile
  /* The following function is implemented in module CRC32.C */
  extern unsigned long CreateCRC32(unsigned long ulCRC, unsigned char* pabBuffer, unsigned long ulLength);
  DBMLIB_RESULT __OS_WIN32AllocateMemory(void FAR* FAR* pp, size_t n);
  DBMLIB_RESULT __OS_WIN32FreeMemory(void FAR* p);
  /* The following functions are only referenced in the Mid_DbmOSWrapper.c Module itself.
  */
  DBMLIB_RESULT __OS_WIN32OpenFile(CONST STRING FAR* psz, MID_FAT_FILEACCESS dw, HANDLE FAR* ph);
  DBMLIB_RESULT __OS_WIN32CreateFile(CONST STRING FAR* psz, HANDLE FAR* ph);
  DBMLIB_RESULT __OS_WIN32WriteFile(CONST CHAR  FAR* pszFilename,
                            CONST UINT8 FAR* pbBuffer,
                            UINT32           ulBufferLen);
/* ****************************************************************************************************** 
                      END of definitions when compiled with the OS Windows 
 ****************************************************************************************************** */
#endif /*#ifdef _WIN32*/

/* START to be changed */
/* copy the whole section between #ifdef _UserDefinedName and the corresponding #endif and 
make the changes described on each 'START to be changed' string
Leave the section _UserDefinedName unchanged as a template for other developers.
*/
#ifdef _UserDefinedName
/* ****************************************************************************************************** 
                    START of definitions when compiled with the User specific OS 
 ****************************************************************************************************** */
#define _MID_DATABASE_ENABLE_     /* Start compilation of the DBM Modules */
/* START to be changed */
/* rename the __OS_UserDefinedName with your own name */
#define __OS_UserDefinedName      /* define the OS to use during compilation */
/* START to be changed */

#ifdef __cplusplus
#endif /*#ifdef __cplusplus*/

/* START to be changed */
/* Include the files which are needed to compile the sources in your environment
*/
#include <windows.h>
#include <basetsd.h>
#include <tchar.h>
/*#include <assert.h>*/
/* END to be changed */

#undef _RX_CHECK_INTEGRITY_

/* GlobalDefinitions
*/
/* START to be changed */
/* Define the pointer width for parameters if supported by your compiler */
#undef FAR
#define FAR
#undef HUGE
#define HUGE
/* END to be changed */

#define RX_FATAL  DBMLIB_RESULT
/* START to be changed */
/* Give the defines for a file handle in your environment */
#define RX_HANDLE void FAR*
/* Define the calling convention of the functions when you need to create a dll. */
/* END to be changed */

#define __RCX_PUBLIC_H
typedef struct RCX_FILE_GET_MD5_CNF_DATA_Ttag
{
  UINT8                               abMD5[16];              /* MD5 checksum */
} RCX_FILE_GET_MD5_CNF_DATA_T;

/* START to be changed */
/* The BOUNDARY macro will affect the writing of a database because 
each structure is written in a way that it will start on a boundary address.
For use in windows and on CE assume a 32bit prozessor and set the boundarys to 4Byte addresses*/
#define BOUNDARY      BOUNDARY_4 
/* END to be changed */
#define IS_BOUNDARY_ADR(a) ((((DWORD)a)%BOUNDARY==0)?TRUE:FALSE)

/* Because the Table names only support 1 byte character strings */
typedef char  STRING;

/* START to be changed */
/* Map the string and memory functions onto the functions supported by your environment
and dont forget that those functions need to be multithreading capable in a multitasking
OS. */
#define TCSNCMP   _tcsncmp
#define TCSLEN    _tcslen
#define TCSNCPY   _tcsncpy
#define TCSCPY    _tcscpy
#define TCSCMP    _tcscmp

#define STRNCMP   strncmp
#define STRLEN    strlen
#define STRNCPY   strncpy
#define STRCPY    strcpy
#define STRCMP    strcmp

/* Memory function definition */
#define MEMCPY    memcpy
#define MEMSET    memset
#define MEMCMP    memcmp
/* END to be changed */

enum RX_OBJECT_TYPEtag {
  RX_OBJECT_FILE          = 29,
  RX_OBJECT_DBM           = 31
};
typedef UINT8 RX_OBJECT_TYPE;


typedef struct RX_OBJECT_HEADER_Ttag
{
  STRING                        szObjNam[16];   /*< Identification string as 15 + 1 byte String */
  RX_OBJECT_TYPE                eObjType;       /*< Type of Object */
  struct RX_OBJECT_HEADER_Ttag FAR* ptHdrSlf;       /*< Pointer to structure itself to detect if still valid */
} RX_OBJECT_HEADER_T;

/* define the file access flags
*/
enum MID_FAT_FILEACCESStag {
  MID_FAT_FILEACCESS_NORMAL = 0,
  MID_FAT_FILEACCESS_READONLY = 1,
};

typedef int           MID_FAT_FILEACCESS;

#pragma warning ( disable: 4028 )

/* START to be changed */
/* The following is a mapping list of referenced functions in the DBM-Modules to the implementation
  in Mid_DbmOSWrapper.c 
  You will find a section with predefined __OS_UserDefined... functions in the Mid_DbmOSWrapper.c file.
  This section should be copied and the __OS_UserDefined prefix should be renamed with your own OS name.
  Then you have to go to each of these functions and write your own code if needed.
*/
  #define MidDatabaseInit                     __OS_UserDefinedNameDatabaseInit
  #define Mid_DbmCloseDbmFile                 __OS_UserDefinedNameCloseDbmFile
  #define Mid_DbmOpenDbmFile                  __OS_UserDefinedNameOpenDbmFile
  #define MidSys_Crc32                        __OS_UserDefinedNameCrc32
  #define rX_MemAllocateMemory                __OS_UserDefinedNameAllocateMemory
  #define rX_MemFreeMemory                    __OS_UserDefinedNameFreeMemory
  #define APCFG_WriteFile                     __OS_UserDefinedNameWriteFile
  /* The following function is implemented in module CRC32.C */
  extern unsigned long CreateCRC32(unsigned long ulCRC, unsigned char* pabBuffer, unsigned long ulLength);
  DBMLIB_RESULT __OS_UserDefinedNameAllocateMemory(void FAR* FAR* pp, size_t n);
  DBMLIB_RESULT __OS_UserDefinedNameFreeMemory(void FAR* p);
  /* The following functions are only referenced in the Mid_DbmOSWrapper.c Module itself.
  */
  DBMLIB_RESULT __OS_UserDefinedNameOpenFile(CONST STRING FAR* psz, MID_FAT_FILEACCESS dw, HANDLE FAR* ph);
  DBMLIB_RESULT __OS_UserDefinedNameCreateFile(CONST STRING FAR* psz,HANDLE FAR* ph);
  DBMLIB_RESULT __OS_UserDefinedNameWriteFile(CONST CHAR  FAR* pszFilename,
                            CONST UINT8 FAR* pbBuffer,
                            UINT32           ulBufferLen);
/* END to be changed */
/* ****************************************************************************************************** 
                      END of definitions when compiled with the OS Windows-CE 
 ****************************************************************************************************** */
#endif /*#ifdef _UserDefinedName*/
/* END to be changed */

/*!
***********************************************************
*  File types of a database
***********************************************************
*/
enum eFileType {
  eFileTypeNone,    /*< Unknown file type*/
  eFileTypeRCSDbm,  /*< RCS compatible (old) database*/
  eFileTypeRCXDbm,  /*< old RCX compatible (obsolete) database*/
  eFileTypeNETXDbm, /*< new RCS compatible (actual) database*/
};
/*!
***********************************************************
*  definitions to enumerate
***********************************************************
*/
enum eDbmFN {
  eDbmFirst,
  eDbmNext,
  eDbmNone
};
/*!
***********************************************************
*  enumerator for access types
***********************************************************
*/
enum eDbmRW {
  eDbmReadAccess,
  eDbmWriteAccess,
};

typedef struct MID_DBM_DBMFILE_Ttag {
  RX_OBJECT_HEADER_T tObjHdr;  /*< Header Data */
  enum eFileType     m_eFileType; /*< Type of the file (see eFileType)*/
  UINT8 FAR*         pbDbmFile; /*< Physical pointer to DBM-File */
  UINT32             ulSiz; /*< Size of the DBM-File */
  UINT               uOpnCnt; /*< Counter of how often the same File has been opened */
  UINT32             ulDirectory; /*< Start Cluster of directory for file, to support opening files with the same name in different directories */
} MID_DBM_DBMFILE_T;     


#ifdef _DEBUG
void FAR DbmLibAssert(STRING FAR* pszExpr, STRING FAR* pszFile, UINT16 wLine);
#define assert(exp) if( !(exp) ){DbmLibAssert(#exp, __FILE__, __LINE__);}
#else
#define assert(exp)
#endif
#define VALIDATE_PTR(ptr,type)  assert (ptr!=NULL && (ptr)->m_lStructType==type)

#define CONCAT_P(n) P##n
#define VALIDATE_HANDLE(ptr, name, type)  (ptr!=NULL && ( ( CONCAT_P(name) ) ptr )->m_lStructType==type)

/* ****************************************************************************************************** 
                    START the following stuff is needed in the sources  
 ****************************************************************************************************** */
#include "Mid_Dbm.h"   /* Database management */
#include "Mid_DbmDyn.h"   /* dynamic Database management */
#include "Mid_DbmDynHlp.h"   /* dynamic Database helper*/
#include "ap_dbm.h"
#include "ap_dbmdyn.h"

#ifdef __OS_RCX
  /* Include special header for this OS here */
#endif /*#ifdef __OS_RCX*/

#ifdef __OS_WIN32
  /* Include special header for this OS here */
//#pragma warning (pop)
#endif /*#ifdef _WIN32*/

#ifdef __OS_WIN32_WCE
  /* Include special header for this OS here */
#endif /*#ifdef _WIN32_WCE*/

#ifdef __OS_UserDefinedName
  /* Include special header for this OS here */
#endif /*#ifdef _WIN32_WCE*/

#endif /*inclusion lock*/  
